' Copyright (C) 2023 Redfast Inc - All Rights Reserved
'
' Must not be copied and/or distributed without the express
' permission of Redfast Inc

sub init()
    m.currentScreenName = ""
    m.allResults = PromotionResult()
    m.allErrors = ErrorMessage()
    m.billing = m.top.FindNode("billing")
    m.pingRetry = 60
    m.lastEtag = invalid
    m.lastGoodPingInterval = 60
    di = CreateObject("roDeviceInfo")
    m.displaySize = di.GetDisplaySize()
    m.localStorage = CreateLocalStorage()
    m.localStorage.reset(true)
    m.modalParamsDictionary = {}
    m.promotionEnabled = true
end sub

function callApi(observer as string) as object
    action = createObject("RoSGNode", "PromotionApi")
    action.appId = m.appId
    action.userId = m.userId
    action.deviceType = m.deviceType
    if m.anonymousUserId <> invalid and m.anonymousUserId <> ""
        action.anonymous_user_id = m.anonymousUserId
    end if
    if m.actions <> invalid and m.actions.anonymous_user_id <> invalid
        action.anonymous_user_id = m.actions.anonymous_user_id
    end if
    if observer <> ""
        action.observeField("state", observer)
    end if
    return action
end function

sub initPromotion(params as object)
    m.actions = invalid
    m.initialPing = true
    m.appId = params.appId
    m.userId = params.userId
    m.anonymousUserId = params.anonymousUserId
    m.deviceType = "roku_os"
    m.fonts = { ctaFont: params.ctaFont, timeoutFont: params.timeoutFont }
    if params.deviceType <> invalid
        m.deviceType = params.deviceType
    end if
    updatePing()
end sub

sub ping(params as object)
    params.event = "traitping"
    m.ping = callApi("")
    m.ping.callFunc("fireEvent", params)
end sub

sub enablePromotion(params as object)
    if Type(params.enabled) = "roBoolean"
        m.promotionEnabled = params.enabled
    end if
end sub

sub updatePing()
    if m.initialPing and m.timer <> invalid
        m.timer.unobserveField("fire")
        m.timer = invalid
    end if
    if m.promotionEnabled
        m.ping = callApi("onUpdatePing")
        m.ping.callFunc("fireEvent", { event: "ping", name: m.currentScreenName, etag: m.lastEtag })
    else
        print "Rf: promotion is temporary disabled; idle timer"
        m.timer = createObject("RoSGNode", "Timer")
        m.timer.duration = m.pingRetry
        m.timer.observeField("fire", "updatePing")
        m.timer.repeat = false
        m.timer.control = "start"
        m.actions = invalid
    end if
end sub

function scheduleNextPingInterval() as integer
    m.lastEtag = invalid
    nextInterval = m.pingRetry
    m.pingRetry = m.pingRetry * 2
    if m.pingRetry > 3084
        m.pingRetry = 3084
    end if
    return nextInterval
end function

sub onUpdatePing()
    if m.ping.state = "stop"
        m.ping.unobserveField("fireEvent")
        interval = m.pingRetry
        if m.ping.content <> invalid
            m.actions = m.ping.content
            if m.ping.content.configs <> invalid and m.ping.content.configs.ping_frequency <> invalid
                if m.initialPing
                    m.initialPing = false
                    m.top.result = { code: m.allResults.ok }
                end if
                interval = m.ping.content.configs.ping_frequency
                m.lastEtag = m.ping.content.etag
                m.lastGoodPingInterval = interval
                m.pingRetry = 60
            else if m.ping.content.etag <> invalid
                m.lastEtag = m.ping.content.etag
                interval = m.lastGoodPingInterval
            else
                interval = scheduleNextPingInterval()
            end if

            if m.actions.reset <> invalid and m.actions.reset = true
                resetGoal()
            end if
        else
            interval = scheduleNextPingInterval()
        end if
        print "Rf: next ping after " + interval.toStr() + " seconds"
        m.timer = createObject("RoSGNode", "Timer")
        m.timer.duration = interval
        m.timer.observeField("fire", "updatePing")
        m.timer.repeat = false
        m.timer.control = "start"
        m.ping = invalid
    end if
end sub

function getPath(actions as object, clickId as string) as object
    paths = []
    pathTypes = PathType()
    if actions.paths <> invalid
        for ii = 0 to actions.paths.count() - 1
            path = actions.paths[ii]
            if path.path_type = pathTypes.modal or path.path_type = pathTypes.interstitial or path.path_type = pathTypes.video or path.path_type = pathTypes.bottomBanner
                paths.push(path)
            end if
        end for
    end if

    for ii = 0 to paths.count() - 1
        path = paths[ii]
        for jj = 0 to path.triggers.count() - 1
            trigger = path.triggers[jj]
            urlPath = trigger.url_path
            useRegex = trigger.use_regex
            checkTriggerScreenName = false
            if useRegex <> invalid and useRegex
                pattern = CreateObject("roRegex", urlPath, "")
                checkTriggerScreenName = pattern.IsMatch(m.currentScreenName)
            else if urlPath = m.currentScreenName
                checkTriggerScreenName = true
            end if
            if checkTriggerScreenName
                if (trigger.click_id = invalid or trigger.click_id = "") and clickId = ""
                    path.delay_seconds = trigger.delay_seconds
                    return path
                end if
                if trigger.click_id = clickId
                    path.delay_seconds = trigger.delay_seconds
                    return path
                end if
            end if
        end for
    end for
    return invalid
end function

sub onInlineClicked(params as object)
    track = callApi("")
    for ii = 0 to m.actions.paths.count() - 1
        path = m.actions.paths[ii]
        if path.id = params.pathId
            track.callFunc("fireEvent", { event: "goal", pathId: params.pathId, actionGroupId: params.actionGroupId })
            m.top.result = preparePromptResult({
                code: m.allResults.button1,
                meta: path.actions.rf_metadata,
                deeplink: path.actions.rf_settings_deeplink
            }, path)
            return
        end if
    end for
    m.top.result = {
        code: m.allResults.notApplicable,
        value: { error: "invalid path id " + params.pathId }
    }
end sub

sub onInlineDismissed(params as object)
    track = callApi("")
    for ii = 0 to m.actions.paths.count() - 1
        path = m.actions.paths[ii]
        if path.id = params.pathId
            track.callFunc("fireEvent", { event: "dismiss", pathId: params.pathId, actionGroupId: params.actionGroupId, reason: "dismiss" })
            m.top.result = preparePromptResult({
                code: m.allResults.dismissed,
            }, path)
            return
        end if
    end for
    m.top.result = {
        code: m.allResults.notApplicable,
        value: { error: "invalid path id " + params.pathId }
    }
end sub

sub onInlineViewed(params as object)
    track = callApi("")
    for ii = 0 to m.actions.paths.count() - 1
        path = m.actions.paths[ii]
        if path.id = params.pathId
            track.callFunc("fireEvent", { event: "impression", pathId: params.pathId, actionGroupId: params.actionGroupId })
            m.top.result = preparePromptResult({
                code: m.allResults.impression,
            }, path)
            return
        end if
    end for
    m.top.result = {
        code: m.allResults.notApplicable,
        value: { error: "invalid path id " + params.pathId }
    }
end sub

sub onButtonClicked(params as object)
    if m.actions = invalid
        m.top.lastError = m.allErrors.invalid_action
        return
    end if

    path = getPath(m.actions, params.id)
    if path <> invalid
        modalParam = {}
        modalParam.appId = m.appId
        modalParam.userId = m.userId
        modalParam.deviceType = m.deviceType
        modalParam.path = path
        modalParam.root = params.root
        m.modalParamsDictionary.addReplace(m.currentScreenName, modalParam)
        onDisplayModal()
    else
        m.top.result = { code: m.allResults.notApplicable }
    end if

    usages = m.actions.configs.usage
    for kk = 0 to usages.count() - 1
        usage = usages[kk]
        if usage.type = "track"
            values = usage.values
            for ll = 0 to values.count() - 1
                value = values[ll]
                if params.id = value
                    click = callApi("")
                    click.callFunc("fireEvent", { event: "click", id: usage.id, type: usage.type, eventName: usage.event, value: value })
                    exit for
                end if
            end for
        end if
    end for
end sub

sub onModalDismissed()
    m.modal.unobserveField("result")
    m.modalParam.root.removeChildIndex(m.modalParam.root.getChildCount() - 1)

    m.modalResult = m.modal.result
    m.modal = invalid
    prod_id = m.modalParam.path.actions.rf_settings_roku_product_id
    prod_op = m.modalParam.path.actions.rf_settings_roku_product_operation
    if prod_id <> invalid and prod_op <> invalid and prod_id <> "" and prod_op <> ""
        m.billing.ObserveField("catalog", "inAppUpdate1")
        m.billing.command = "getCatalog"
    else
        m.top.result = m.modalResult
        m.modalParam = invalid
    end if
    m.modalParamsDictionary = {}
    m.screenChangeDelay = invalid
end sub

sub inAppUpdate1()
    m.billing.unobserveField("catalog")
    m.catalog = m.billing.catalog
    for ii = 0 to m.catalog.getChildCount() - 1
        item = m.catalog.getChild(ii)
        if item.id = m.modalParam.path.actions.rf_settings_roku_product_id
            print "inapp update: found product id"
            m.updateItem = item
            m.billing.ObserveField("purchases", "inAppUpdate2")
            m.billing.command = "getPurchases"
            return
        end if
    end for
    m.top.result = m.modalResult
    m.modalParam = invalid
end sub

sub inAppUpdate2()
    m.billing.unobserveField("purchases")
    m.purchased = m.billing.purchases
    for ii = 0 to m.purchased.getChildCount() - 1
        item = m.purchased.getChild(ii)
        if item.id = m.modalParam.path.actions.rf_settings_roku_product_id
            print "inapp update: already purchased"
            m.top.result = m.modalResult
            m.modalParam = invalid
            return
        end if
    end for

    orders = CreateObject("roSGNode", "ContentNode")
    order = orders.createChild("ContentNode")
    order.addFields({ "code": m.updateItem.id, "qty": 1 })
    orders.action = m.modalParam.path.actions.rf_settings_roku_product_operation
    m.billing.order = orders
    m.billing.ObserveField("orderStatus", "inAppUpdate3")
    m.billing.command = "doOrder"
end sub

sub inAppUpdate3()
    m.billing.unobserveField("orderStatus")
    m.modalResult.orderStatus = m.billing.orderStatus.status
    m.top.result = m.modalResult
    m.modalParam = invalid
end sub

sub onScreenChanged(params as object)
    if m.promotionEnabled = false
        print "Rf: SDK disabled - " + params.screenName
        return
    end if
    print "Rf: onScreenChanged - " + params.screenName
    m.currentScreenName = params.screenName
    if m.actions = invalid
        m.top.lastError = m.allErrors.invalid_action
        return
    end if

    path = getPath(m.actions, "")
    if path <> invalid
        modalParam = {}
        modalParam.appId = m.appId
        modalParam.userId = m.userId
        modalParam.deviceType = m.deviceType
        if path.action_group_id = invalid then path.action_group_id = ""
        modalParam.path = path
        modalParam.root = params.root
        m.modalParamsDictionary.addReplace(m.currentScreenName, modalParam)

        if m.screenChangeDelay <> invalid
            m.screenChangeDelay.control = "stop"
            m.screenChangeDelay = invalid
        end if
        if (path.delay_seconds > 0)
            m.screenChangeDelay = createObject("RoSGNode", "Timer")
            m.screenChangeDelay.duration = path.delay_seconds
            m.screenChangeDelay.observeField("fire", "onDisplayModal")
            m.screenChangeDelay.repeat = false
            m.screenChangeDelay.control = "start"
        else
            onDisplayModal()
        end if
    end if
end sub

sub onHoldOutUpdate()
    if m.holdout.state = "stop"
        m.holdout.unobserveField("fireEvent")
        if m.holdout.content <> invalid and m.holdout.content.success = true and m.modalParam <> invalid
            m.localStorage.createHoldOutKey(m.modalParam.path.id)
        end if
    end if
end sub

function isSuppressedByHoldout(path) as boolean
    isPresented = m.localStorage.hasHoldOutPresented(path.id)
    if path.holdout <> invalid and path.holdout = true
        if not isPresented
            m.holdout = callApi("onHoldOutUpdate")
            actionGroupId = ""
            if path.action_group_id <> invalid then actionGroupId = path.action_group_id
            m.holdout.callFunc("fireEvent", { event: "holdout", pathId: path.id, actionGroupId: actionGroupId })
        end if
        print("Rf: promos " + path.id + " is blocked due to isSuppressedByHoldout")
        return true
    end if
    return isPresented
end function

sub onDisplayModal()
    if not m.modalParamsDictionary.DoesExist(m.currentScreenName)
        print "Rf: display modal aborted - screen obsolete"
        return
    end if
    m.modalParam = m.modalParamsDictionary.lookUp(m.currentScreenName)
    print "Rf: display modal for " + m.currentScreenName + ", id=" + m.modalParam.path.id

    if isSuppressedByHoldout(m.modalParam.path)
        m.top.result = { code: m.allResults.holdout }
        return
    end if
    if not m.localStorage.isOverlayEnabled(m.modalParam.path.id)
        m.top.result = { code: m.allResults.suppressed }
        return
    end if

    m.top.result = { code: m.allResults.impression }

    if m.actions <> invalid and m.actions.anonymous_user_id <> invalid
        m.modalParam.anonymous_user_id = m.actions.anonymous_user_id
    end if
    m.modal = invalid
    pathTypes = PathType()
    if m.modalParam.path.path_type = pathTypes.modal or m.modalParam.path.path_type = pathTypes.interstitial or m.modalParam.path.path_type = pathTypes.bottomBanner
        m.modal = createObject("roSGNode", "PromotionDialog")
    else
        m.modal = createObject("roSGNode", "PromotionVideoDialog")
    end if
    m.modal.fonts = m.fonts
    m.modal.observeField("result", "onModalDismissed")
    m.modalParam.root.ObserveField("change", "onChildAdded")
    m.modalParam.root.insertchild(m.modal, m.modalParam.root.getChildCount())
end sub

sub onChildAdded()
    m.modalParam.root.unobserveField("change")
    m.modal.callFunc("showModal", m.modalParam)
end sub

function getInlines(params as object) as object
    row = []
    di = CreateObject("roDeviceInfo")
    displaySize = di.GetDisplaySize()
    if m.actions <> invalid and m.actions.paths <> invalid
        for ii = 0 to m.actions.paths.count() - 1
            path = m.actions.paths[ii]
            isSuppressed = isSuppressedByHoldout(path)
            if not isSuppressed and path.actions.rf_settings_zone_id <> invalid and path.actions.rf_settings_zone_id = params.type
                heightSuffix = ""
                if displaySize.h = 480
                    heightSuffix = "&screen_size=480"
                else if displaySize.h = 720
                    heightSuffix = "&screen_size=720"
                else if displaySize.h = 1080
                    heightSuffix = "&screen_size=1080"
                else
                    heightSuffix = "&screen_size=1080"
                end if
                path.actions.rf_settings_bg_image_roku_os_tv_composite = path.actions.rf_settings_bg_image_roku_os_tv_composite + heightSuffix
                row.push(path)
                impression = callApi("")
                impression.callFunc("fireEvent", { event: "impression", pathId: path.id, actionGroupId: path.action_group_id })
            end if
        end for
    else
        m.top.lastError = m.allErrors.invalid_action
    end if
    return row
end function

sub getIapItems()
    m.billing.ObserveField("catalog", "On_billing_catalog")
    m.billing.command = "getCatalog"
end sub

sub getPuchasedItems()
    m.billing.ObserveField("purchases", "On_get_purchased")
    m.billing.command = "getPurchases"
end sub

sub On_get_purchased()
    m.billing.unobserveField("purchases")
    m.top.iapResult = m.billing.purchases
end sub

sub On_billing_catalog()
    m.billing.unobserveField("catalog")
    m.top.iapResult = m.billing.catalog
end sub

sub purchaseIap(params as object)
    orders = CreateObject("roSGNode", "ContentNode")
    order = orders.createChild("ContentNode")
    order.addFields({ "code": params.sku, "qty": params.qty })
    if params.action <> invalid
        if "Upgrade" = params.action or "Downgrade" = params.action
            orders.action = params.action
        end if
    end if
    m.billing.order = orders
    m.billing.ObserveField("orderStatus", "On_billing_purchaseResult")
    m.billing.command = "doOrder"
end sub

sub On_billing_purchaseResult()
    m.billing.unobserveField("orderStatus")
    m.top.iapResult = m.billing.orderStatus
end sub

sub customTrack(params as object)
    if m.promotionEnabled = false
        print "Rf: SDK disabled - customTrack"
        return
    end if
    track = callApi("")
    track.callFunc("fireEvent", { event: "customTrack", customFieldId: params.customFieldId })
end sub

sub setUserId(params as object)
    m.actions = invalid
    m.userid = params.userId
    updatePing()
end sub

sub setAnonymousUserId(params as object)
    m.actions = invalid
    m.anonymousUserId = params.anonymousUserId
    updatePing()
end sub

function getUserId() as object
    return m.userid
end function

sub resetGoal()
    m.localStorage.reset(false)
    track = callApi("")
    track.callFunc("fireEvent", { event: "resetGoal" })
end sub

function getMetas() as object
    meta = {}
    pathTypes = PathType()
    if m.actions <> invalid and m.actions.paths <> invalid
        for ii = m.actions.paths.count() - 1 to 0 step -1 'reverse order on the paths
            path = m.actions.paths[ii]
            if path.path_type = pathTypes.invisible and path.actions <> invalid and path.actions.rf_metadata <> invalid
                rt_meta = path.actions.rf_metadata
                for each key in rt_meta
                    meta[key] = rt_meta[key]
                end for
            end if
        end for
    end if
    return meta
end function

function getVersion() as string
    return "1.0.36"
end function

function matchStrings(first as string, second as string) as boolean
    if first = second or first = "*" or second = "*"
        return true
    end if

    if first = invalid or second = invalid
        return false
    end if

    asteriskIndex = first.Instr(0, "*")
    if asteriskIndex = -1
        return false
    end if

    if asteriskIndex = 0 ' Starts with *
        suffix = first.Mid(1) ' Substring from index 1 to end
        return suffix = "" or second.endsWith(suffix)
    end if

    if asteriskIndex = first.Len() - 1 ' ends with *
        prefix = first.Left(first.Len() - 1)
        return prefix = "" or second.StartsWith(prefix)
    end if

    return false
end function

function path2Prompt(path as object) as object
    button1 = {
        label: path.actions.rf_retention_button1_text,
        textColor: path.actions.button1_text_color,
        textHightlightColor: path.actions.button1_highlight_color,
        bgColor: path.actions.button1_bg_color,
        width: path.actions.button1_width,
        height: path.actions.button1_height,
        position_x: path.actions.button1_position_x,
        position_y: path.actions.button1_position_y,
    }
    button2 = invalid
    if path.actions.rf_settings_confirm_button_2_enabled = "true"
        button2 = {
            label: path.actions.rf_retention_button2_text,
            textColor: path.actions.button2_text_color,
            textHightlightColor: path.actions.button2_highlight_color,
            bgColor: path.actions.button2_bg_color,
            width: path.actions.button2_width,
            height: path.actions.button2_height,
            position_x: path.actions.button2_position_x,
            position_y: path.actions.button2_position_y,
        }
    end if
    button3 = invalid
    if path.actions.rf_settings_cancel_button_enabled = "true"
        button3 = {
            label: path.actions.rf_retention_button3_text,
            textColor: path.actions.button3_text_color,
            textHightlightColor: path.actions.button3_highlight_color,
            bgColor: path.actions.button3_bg_color,
            width: path.actions.button3_width,
            height: path.actions.button3_height,
            position_x: path.actions.button3_position_x,
            position_y: path.actions.button3_position_y,
        }
    end if
    countDownPromptInvisible = false
    if path.actions.rf_settings_hide_timer_text = "true" then countDownPromptInvisible = true
    prompt = {
        id: path.id,
        type: path.path_type,
        actions: path.actions,
        actionGroupId: path.action_group_id,
        inAppSku: path.actions.rf_settings_roku_product_id,
        deviceMeta: path.actions.rf_metadata,
        deeplink: path.actions.rf_settings_deeplink,
        button1: button1,
        button2: button2,
        button3: button3,
        buttonBorderRadius: path.actions.rf_retention_button_border_radius,
        buttonBorderColor: path.actions.rf_retention_button_border_color,
        buttonBorderThickness: path.actions.rf_retention_button_border_thickness,
        countDownPrompt: path.actions.rf_settings_close_seconds_text,
        countDownPromptColor: path.actions.rf_settings_timer_font_color,
        countDownPromptFontSize: path.actions.rf_settings_timer_font_size,
        countDownPromptInvisible: countDownPromptInvisible,
        countDown: path.actions.rf_settings_close_seconds,
        horizontalPoster: path.actions.rf_settings_bg_image_roku_os_tv_composite,
        pathItem: path
    }
    prompt.impression = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "impression", pathId: m.id, actionGroupId: m.actionGroupId })
    end function
    prompt.dismiss = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "dismiss", pathId: m.id, actionGroupId: m.actionGroupId, reason: "dismiss" })
    end function
    prompt.timeout = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "dismiss", pathId: m.id, actionGroupId: m.actionGroupId, reason: "timeout" })
    end function
    prompt.holdout = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "holdout", pathId: m.id, actionGroupId: m.actionGroupId })
    end function
    prompt.goal = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "goal", pathId: m.id, actionGroupId: m.actionGroupId })
    end function
    prompt.goal2 = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "goal", pathId: m.id, actionGroupId: m.actionGroupId, accept_type: "accept2" })
    end function
    prompt.decline = function()
        track = callApi("")
        track.callFunc("fireEvent", { event: "decline", pathId: m.id, actionGroupId: m.actionGroupId, reason: "decline" })
    end function
    return prompt
end function

function getPrompt(params as object) as object
    pathId = params.pathId
    prompt = invalid
    print("getPrompt called with id: " + pathId)
    if m.actions <> invalid
        for ii = 0 to m.actions.paths.count() - 1
            path = m.actions.paths[ii]
            if path.id = pathId
                prompt = path2Prompt(path)
                exit for
            end if
        end for
    end if
    return prompt
end function

function getPrompts(params as object) as object
    pzType = params.pathType
    zoneId = params.zoneId
    zoneIdName = ""
    if zoneId <> invalid then zoneIdName = zoneId
    pathTypes = PathType()
    prompts = []
    print("getPrompts called with type: " + Str(pzType) + ", zoneId: " + zoneIdName)
    if m.actions <> invalid
        pathItemsFiltered = []
        for ii = 0 to m.actions.paths.count() - 1
            path = m.actions.paths[ii]
            if path.path_type = pzType or pathTypes.all = pzType
                if zoneId = invalid or zoneId = path.actions.rf_settings_zone_id
                    pathItemsFiltered.push(path)
                end if
            end if
        end for

        for ii = 0 to pathItemsFiltered.count() - 1
            path = pathItemsFiltered[ii]
            prompts.push(path2Prompt(path))
        end for
    end if
    return prompts
end function

function getTriggerablePrompts(params as object) as object
    pathTypes = PathType()
    screenName = params.screenName
    clickId = params.clickId
    pzType = params.pathType
    zoneId = params.zoneId
    zoneIdName = ""
    if zoneId <> invalid then zoneIdName = zoneId
    if screenName = invalid then screenName = "*"
    if clickId = invalid then clickId = "*"
    if pzType = invalid then pzType = pathTypes.modal
    print("getTriggerablePrompts called with screenName: " + screenName + ", clickId: " + clickId + ", type: " + Str(pzType) + ", zoneId: " + zoneIdName)

    if screenName = invalid and clickId = invalid then return []

    prompts = getPrompts({ pzType: pzType, zoneId: zoneId })
    filteredPrompts = []
    for ii = 0 to prompts.count() - 1
        prompt = prompts[ii]
        matchedTrigger = invalid
        if prompt.pathItem.triggers <> invalid
            for jj = 0 to prompt.pathItem.triggers.count() - 1
                trigger = prompt.pathItem.triggers[jj]
                matchedScreenName = matchStrings(trigger.url_path, screenName)
                matchedClickId = matchStrings(trigger.click_id, clickId)
                if matchedScreenName and matchedClickId
                    matchedTrigger = trigger
                    exit for
                end if
            end for

            if matchedTrigger <> invalid
                if not isSuppressedByHoldout(prompt.pathItem)
                    if m.localStorage.isOverlayEnabled(prompt.pathItem.id)
                        filteredPrompts.push(prompt)
                    end if
                end if
            end if
        end if
    end for

    return filteredPrompts
end function

function sendPromptEvent(params as object) as object
    event = params.event
    prompt = params.prompt
    if event <> invalid and prompt <> invalid
        id = prompt.id
        actionGroupId = prompt.actionGroupId
        track = callApi("")
        if event = "impression"
            track.callFunc("fireEvent", { event: "impression", pathId: id, actionGroupId: actionGroupId })
        else if event = "dismiss"
            track.callFunc("fireEvent", { event: "dismiss", pathId: id, actionGroupId: actionGroupId, reason: "dismiss" })
        else if event = "timeout"
            track.callFunc("fireEvent", { event: "dismiss", pathId: id, actionGroupId: actionGroupId, reason: "timeout" })
        else if event = "holdout"
            track.callFunc("fireEvent", { event: "holdout", pathId: id, actionGroupId: actionGroupId })
        else if event = "goal"
            track.callFunc("fireEvent", { event: "goal", pathId: id, actionGroupId: actionGroupId })
        else if event = "goal2"
            track.callFunc("fireEvent", { event: "goal", pathId: id, actionGroupId: actionGroupId, accept_type: "accept2" })
        else if event = "decline"
            track.callFunc("fireEvent", { event: "dismiss", pathId: id, actionGroupId: actionGroupId, reason: "decline" })
        end if
    end if
end function

function showPrompt(params as object) as boolean
    displayed = false
    prompt = params.prompt
    root = params.root
    pathTypes = PathType()
    if prompt <> invalid and root <> invalid
        pzType = prompt.type
        if pzType = pathTypes.modal or pzType = pathTypes.interstitial or pzType = pathTypes.bottomBanner or pzType = pathTypes.video
            modalParam = {}
            modalParam.appId = m.appId
            modalParam.userId = m.userId
            modalParam.deviceType = m.deviceType
            modalParam.path = prompt.pathItem
            modalParam.root = root
            m.modalParamsDictionary.addReplace(m.currentScreenName, modalParam)
            onDisplayModal()
            displayed = true
        end if
    end if
    return displayed
end function

function showInline(params as object) as object
    m.inlineRoot = params.root
    scale = "noScale"
    if params.scale <> invalid
        scale = params.scale
    end if
    inlines = getInlines(params)
    if inlines.count() > 0
        m.inline = createObject("roSGNode", "PromotionInline")
        m.inline.fonts = m.fonts
        m.inlineParam = {
            appId: m.appId,
            userId: m.userId,
            deviceType: m.deviceType,
            anonymous_user_id: m.anonymousUserId,
            path: inlines[0],
            parent: m.inlineRoot,
            scale: scale
        }
        m.inlineRoot.ObserveField("change", "onHorizontalAdded")
        m.inlineRoot.insertchild(m.inline, 0)
        width = pxToInteger(inlines[0].actions.prompt_width)
        height = pxToInteger(inlines[0].actions.prompt_height)
        return m.inline
    end if
    return invalid
end function

sub onHorizontalAdded()
    m.inlineRoot.unobserveField("change")
    m.inline.callFunc("showInline", m.inlineParam)
end sub